/****************************************************************************
*  Programm Name    : bios_ser.c           Sprache        :  C              *
*  User System      : Microsoft QC 5.0     Betriebssystem :  MS DOS 4.0     *
*  Programm Wirkung : C-Beispielprogramm  zum ansteuern der RS232           *
*                     im ANSI-Format                                        *
*  Datum            : 19.09.90     MW                                       *
*  gendert am      :                                 von :                 *
*  Copyright by     : burster przisionsmesstechnik                         *
*                     Talstr.1-7                                            *
*                     7562 Gernsbach                                        *
*                     Tel.:07224-645-0                                      *
*                                                                           *
****************************************************************************/

#include <stdio.h>
#include <bios.h>
#include <stdlib.h>
#include <string.h>

#define STX 0x02
#define ETX 0x03
#define EOT 0x04
#define ENQ 0x05
#define ACK 0x06
#define NAK 0x15

#define ERROR_NAK -3
#define OK         1
#define ERROR     -1

   /*----- RS232 ERROR Bit's -------- */

#define TIMEOUT_ERROR   (1<<15)  /* Timeout */
#define TRANS_SHIFT_REG (1<<14)  /* Schieberegister leer */
#define TRANS_HOLD_REG  (1<<13)  /* bertragungsregister leer */
#define BREAK_DETECT    (1<<12)  /* Break Signal */
#define FRAMING_ERROR   (1<<11)  /* Zeitfenster Fehler */
#define PARITY_ERROR    (1<<10)  /* Paritts Fehler */
#define OVERFLOW_ERROR  (1<<9)   /* berlauf Fehler */
#define DATA_READY      (1<<8)   /* Zeichen empfangen */

  /*----- RS232 Status Bit's ----------*/

#define DCD             (1<<7)   /* Daten Carrier-Signal erkannt */
#define RI              (1<<6)   /* Ringindikator */
#define DSR             (1<<5)   /* Daten stehen bereit*/
#define CTS             (1<<4)   /* Sendebereit */
#define DDCD            (1<<3)   /* Delta Daten Carrier-Signal erkannt */
#define TREI            (1<<2)   /* Trailing-Edge-Ringindikator */
#define DDSR            (1<<1)   /* Delta Daten bereit*/
#define DCTS            (1<<0)   /* Delta-Modus sendebereit */


int serial_send(unsigned,char *,char *,char *);
int serial_receive(unsigned,char*,char*,char*,char*);
void com_status(int );
void main (void);

char   buffer[100];

void main (void)
{
	 unsigned com;

	 printf("\n Welche COM : ? ");
	 scanf("%d",&com);

	 com_status(com);

	 _bios_serialcom(_COM_INIT,com,(_COM_9600 | _COM_CHR8 |
			 _COM_STOP2 | _COM_NOPARITY ) );

	 serial_send(com,"00","nb",NULL); /* NO Broad Cast */


	 serial_receive(com,"00","pv",NULL,buffer);
	 printf("Buffer : %s\n",buffer);
}
int serial_send(com,adresse,cmd,msg)
unsigned com;
char * adresse;
char * cmd;
char * msg;
{
	 char *send_buffer;
	 char c = '\0';
	 unsigned ret;
	 char r = '\0';
	 int i=0;

	 send_buffer = calloc (30,sizeof( char));


	 if( strcmp(msg,NULL) == 0)
	 {
	  sprintf(send_buffer,"%c%s%s%c",EOT,adresse,cmd,ENQ);
	  do
	  {
	     ret =_bios_serialcom(_COM_SEND,com,*send_buffer);
	  }
	  while( *send_buffer++ != ENQ);
	 }
	 else
	 {
	  sprintf(send_buffer,"%c%s%s%c%s%c",EOT,adresse,cmd,STX,msg,ETX);
	  do
	  {
	     ret =_bios_serialcom(_COM_SEND,com,*send_buffer);
	  }
	  while( *send_buffer++ != ETX);
	 }

	 /*------------ Wait ACK -------*/
	 do
	 {
	   ret =_bios_serialcom(_COM_RECEIVE,com,r);
	   if (ret & TIMEOUT_ERROR)
	   {
	    printf("Wait ACK Timeout\n");  /* Timeout abfangen */
	    return ERROR;
	   }
	   if ( ret == NAK)
	   {
	    printf("Send NAK\n");
	    return ERROR_NAK;
	   }
	   if ( ret == ACK)
	    return OK;
	 }
	 while(1);
}
int serial_receive(com,adresse,cmd,msg,receive_buffer)
unsigned com;
char * adresse;
char * cmd;
char * msg;
char * receive_buffer;
{
	 char *send_buffer;
	 unsigned ret;
	 char r = '\0';
	 int receive ;
	 int i=0;

	 send_buffer = calloc (30,sizeof( char));

	 if( strcmp(msg,NULL) == 0)
	 {
	  sprintf(send_buffer,"%c%s%s%c",EOT,adresse,cmd,ENQ);
	  /*printf("\n buffer :%s \n",send_buffer);*/
	  do
	  {
	     ret =_bios_serialcom(_COM_SEND,com,*send_buffer);
	  }
	  while( *send_buffer++ != ENQ);
	 }
	 else
	 {
	  sprintf(send_buffer,"%c%s%s%c%s%c",EOT,adresse,cmd,STX,msg,ETX);
	  /*printf("\n buffer :%s \n",send_buffer);*/
	  do
	  {
	     ret =_bios_serialcom(_COM_SEND,com,*send_buffer);
	  }
	  while( *send_buffer++ != ETX);
	 }

	 /*------------ Receive -------*/
	 receive = 0;   /* flag reset */
	 i=0;
	 do
	 {
	   ret =_bios_serialcom(_COM_RECEIVE,com,r);

	   if (ret & TIMEOUT_ERROR)  /* Timeout abfangen */
	   {
	    printf("Receive Timeout\n");
	    return ERROR;
	   }
	   switch( ret )
	   {
	    case ETX:    /* alles erhalten */
	     _bios_serialcom(_COM_SEND,com,ACK);  /*sende ACK */
	     receive = OK;
	     break;
	    case NAK :
	     printf("Receive NAK\n");
	     return ERROR_NAK;
	    default :
	     *receive_buffer++ = (char) ret;  /* speichern */
	     i++;
	   }
	 }
	 while(receive != OK);
	 receive_buffer = receive_buffer-i;
}
void com_status(int com)
{
	 unsigned comstatus;

	 comstatus = _bios_serialcom(_COM_STATUS,com,0);
	 printf("Com Status : 0x%x \n",comstatus);

	 if (comstatus & TIMEOUT_ERROR)
	   printf("Timeout Error\n");

	 if (comstatus & TRANS_SHIFT_REG)
	   printf("Schieberegister leer\n");

	 if (comstatus & TRANS_HOLD_REG)
	   printf("bertragungsregister leer\n");

	 if (comstatus & BREAK_DETECT)
	   printf("Break Error\n");

	 if (comstatus & FRAMING_ERROR)
	   printf("Framing Error\n");

	 if (comstatus & PARITY_ERROR)
	   printf("Parity Error\n");

	 if (comstatus & OVERFLOW_ERROR)
	   printf("Overflow Error\n");

	 if (comstatus & DATA_READY)
	   printf("Data Ready\n");

	 if (comstatus & DCD)
	   printf("Daten Carrier-Signal erkannt \n");

	 if (comstatus & RI)
	   printf("Ringindikator\n");

	 if (comstatus & DSR)
	   printf("Daten stehen bereit\n");

	 if (comstatus & CTS)
	   printf("Sendebereit\n");

	 if (comstatus & DDCD)
	   printf("Delta Daten Carrier-Signal erkannt\n");

	 if (comstatus & TREI)
	   printf("Trailing-Edge-Ringindikator \n");

	 if (comstatus & DDSR)
	   printf("Delta Daten bereit\n");

	 if (comstatus & DCTS)
	   printf("Delta-Modus sendebereit\n");

}
